use crate::v4::scoring::MacroVector;

/// `MacroVector` scores
///
/// <https://github.com/FIRSTdotorg/cvss-v4-calculator/blob/c5b0d409ae9f57c44264c6ce5f27d89298e1d32a/cvss_lookup.js>
pub(super) fn lookup_global(m: &MacroVector) -> Option<f64> {
    match m.as_tuple() {
        (0, 0, 0, 0, 0, 0) => Some(10.0),
        (0, 0, 0, 0, 0, 1) => Some(9.9),
        (0, 0, 0, 0, 1, 0) => Some(9.8),
        (0, 0, 0, 0, 1, 1) => Some(9.5),
        (0, 0, 0, 0, 2, 0) => Some(9.5),
        (0, 0, 0, 0, 2, 1) => Some(9.2),
        (0, 0, 0, 1, 0, 0) => Some(10.0),
        (0, 0, 0, 1, 0, 1) => Some(9.6),
        (0, 0, 0, 1, 1, 0) => Some(9.3),
        (0, 0, 0, 1, 1, 1) => Some(8.7),
        (0, 0, 0, 1, 2, 0) => Some(9.1),
        (0, 0, 0, 1, 2, 1) => Some(8.1),
        (0, 0, 0, 2, 0, 0) => Some(9.3),
        (0, 0, 0, 2, 0, 1) => Some(9.0),
        (0, 0, 0, 2, 1, 0) => Some(8.9),
        (0, 0, 0, 2, 1, 1) => Some(8.0),
        (0, 0, 0, 2, 2, 0) => Some(8.1),
        (0, 0, 0, 2, 2, 1) => Some(6.8),
        (0, 0, 1, 0, 0, 0) => Some(9.8),
        (0, 0, 1, 0, 0, 1) => Some(9.5),
        (0, 0, 1, 0, 1, 0) => Some(9.5),
        (0, 0, 1, 0, 1, 1) => Some(9.2),
        (0, 0, 1, 0, 2, 0) => Some(9.0),
        (0, 0, 1, 0, 2, 1) => Some(8.4),
        (0, 0, 1, 1, 0, 0) => Some(9.3),
        (0, 0, 1, 1, 0, 1) => Some(9.2),
        (0, 0, 1, 1, 1, 0) => Some(8.9),
        (0, 0, 1, 1, 1, 1) => Some(8.1),
        (0, 0, 1, 1, 2, 0) => Some(8.1),
        (0, 0, 1, 1, 2, 1) => Some(6.5),
        (0, 0, 1, 2, 0, 0) => Some(8.8),
        (0, 0, 1, 2, 0, 1) => Some(8.0),
        (0, 0, 1, 2, 1, 0) => Some(7.8),
        (0, 0, 1, 2, 1, 1) => Some(7.0),
        (0, 0, 1, 2, 2, 0) => Some(6.9),
        (0, 0, 1, 2, 2, 1) => Some(4.8),
        (0, 0, 2, 0, 0, 1) => Some(9.2),
        (0, 0, 2, 0, 1, 1) => Some(8.2),
        (0, 0, 2, 0, 2, 1) => Some(7.2),
        (0, 0, 2, 1, 0, 1) => Some(7.9),
        (0, 0, 2, 1, 1, 1) => Some(6.9),
        (0, 0, 2, 1, 2, 1) => Some(5.0),
        (0, 0, 2, 2, 0, 1) => Some(6.9),
        (0, 0, 2, 2, 1, 1) => Some(5.5),
        (0, 0, 2, 2, 2, 1) => Some(2.7),
        (0, 1, 0, 0, 0, 0) => Some(9.9),
        (0, 1, 0, 0, 0, 1) => Some(9.7),
        (0, 1, 0, 0, 1, 0) => Some(9.5),
        (0, 1, 0, 0, 1, 1) => Some(9.2),
        (0, 1, 0, 0, 2, 0) => Some(9.2),
        (0, 1, 0, 0, 2, 1) => Some(8.5),
        (0, 1, 0, 1, 0, 0) => Some(9.5),
        (0, 1, 0, 1, 0, 1) => Some(9.1),
        (0, 1, 0, 1, 1, 0) => Some(9.0),
        (0, 1, 0, 1, 1, 1) => Some(8.3),
        (0, 1, 0, 1, 2, 0) => Some(8.4),
        (0, 1, 0, 1, 2, 1) => Some(7.1),
        (0, 1, 0, 2, 0, 0) => Some(9.2),
        (0, 1, 0, 2, 0, 1) => Some(8.1),
        (0, 1, 0, 2, 1, 0) => Some(8.2),
        (0, 1, 0, 2, 1, 1) => Some(7.1),
        (0, 1, 0, 2, 2, 0) => Some(7.2),
        (0, 1, 0, 2, 2, 1) => Some(5.3),
        (0, 1, 1, 0, 0, 0) => Some(9.5),
        (0, 1, 1, 0, 0, 1) => Some(9.3),
        (0, 1, 1, 0, 1, 0) => Some(9.2),
        (0, 1, 1, 0, 1, 1) => Some(8.5),
        (0, 1, 1, 0, 2, 0) => Some(8.5),
        (0, 1, 1, 0, 2, 1) => Some(7.3),
        (0, 1, 1, 1, 0, 0) => Some(9.2),
        (0, 1, 1, 1, 0, 1) => Some(8.2),
        (0, 1, 1, 1, 1, 0) => Some(8.0),
        (0, 1, 1, 1, 1, 1) => Some(7.2),
        (0, 1, 1, 1, 2, 0) => Some(7.0),
        (0, 1, 1, 1, 2, 1) => Some(5.9),
        (0, 1, 1, 2, 0, 0) => Some(8.4),
        (0, 1, 1, 2, 0, 1) => Some(7.0),
        (0, 1, 1, 2, 1, 0) => Some(7.1),
        (0, 1, 1, 2, 1, 1) => Some(5.2),
        (0, 1, 1, 2, 2, 0) => Some(5.0),
        (0, 1, 1, 2, 2, 1) => Some(3.0),
        (0, 1, 2, 0, 0, 1) => Some(8.6),
        (0, 1, 2, 0, 1, 1) => Some(7.5),
        (0, 1, 2, 0, 2, 1) => Some(5.2),
        (0, 1, 2, 1, 0, 1) => Some(7.1),
        (0, 1, 2, 1, 1, 1) => Some(5.2),
        (0, 1, 2, 1, 2, 1) => Some(2.9),
        (0, 1, 2, 2, 0, 1) => Some(6.3),
        (0, 1, 2, 2, 1, 1) => Some(2.9),
        (0, 1, 2, 2, 2, 1) => Some(1.7),
        (1, 0, 0, 0, 0, 0) => Some(9.8),
        (1, 0, 0, 0, 0, 1) => Some(9.5),
        (1, 0, 0, 0, 1, 0) => Some(9.4),
        (1, 0, 0, 0, 1, 1) => Some(8.7),
        (1, 0, 0, 0, 2, 0) => Some(9.1),
        (1, 0, 0, 0, 2, 1) => Some(8.1),
        (1, 0, 0, 1, 0, 0) => Some(9.4),
        (1, 0, 0, 1, 0, 1) => Some(8.9),
        (1, 0, 0, 1, 1, 0) => Some(8.6),
        (1, 0, 0, 1, 1, 1) => Some(7.4),
        (1, 0, 0, 1, 2, 0) => Some(7.7),
        (1, 0, 0, 1, 2, 1) => Some(6.4),
        (1, 0, 0, 2, 0, 0) => Some(8.7),
        (1, 0, 0, 2, 0, 1) => Some(7.5),
        (1, 0, 0, 2, 1, 0) => Some(7.4),
        (1, 0, 0, 2, 1, 1) => Some(6.3),
        (1, 0, 0, 2, 2, 0) => Some(6.3),
        (1, 0, 0, 2, 2, 1) => Some(4.9),
        (1, 0, 1, 0, 0, 0) => Some(9.4),
        (1, 0, 1, 0, 0, 1) => Some(8.9),
        (1, 0, 1, 0, 1, 0) => Some(8.8),
        (1, 0, 1, 0, 1, 1) => Some(7.7),
        (1, 0, 1, 0, 2, 0) => Some(7.6),
        (1, 0, 1, 0, 2, 1) => Some(6.7),
        (1, 0, 1, 1, 0, 0) => Some(8.6),
        (1, 0, 1, 1, 0, 1) => Some(7.6),
        (1, 0, 1, 1, 1, 0) => Some(7.4),
        (1, 0, 1, 1, 1, 1) => Some(5.8),
        (1, 0, 1, 1, 2, 0) => Some(5.9),
        (1, 0, 1, 1, 2, 1) => Some(5.0),
        (1, 0, 1, 2, 0, 0) => Some(7.2),
        (1, 0, 1, 2, 0, 1) => Some(5.7),
        (1, 0, 1, 2, 1, 0) => Some(5.7),
        (1, 0, 1, 2, 1, 1) => Some(5.2),
        (1, 0, 1, 2, 2, 0) => Some(5.2),
        (1, 0, 1, 2, 2, 1) => Some(2.5),
        (1, 0, 2, 0, 0, 1) => Some(8.3),
        (1, 0, 2, 0, 1, 1) => Some(7.0),
        (1, 0, 2, 0, 2, 1) => Some(5.4),
        (1, 0, 2, 1, 0, 1) => Some(6.5),
        (1, 0, 2, 1, 1, 1) => Some(5.8),
        (1, 0, 2, 1, 2, 1) => Some(2.6),
        (1, 0, 2, 2, 0, 1) => Some(5.3),
        (1, 0, 2, 2, 1, 1) => Some(2.1),
        (1, 0, 2, 2, 2, 1) => Some(1.3),
        (1, 1, 0, 0, 0, 0) => Some(9.5),
        (1, 1, 0, 0, 0, 1) => Some(9.0),
        (1, 1, 0, 0, 1, 0) => Some(8.8),
        (1, 1, 0, 0, 1, 1) => Some(7.6),
        (1, 1, 0, 0, 2, 0) => Some(7.6),
        (1, 1, 0, 0, 2, 1) => Some(7.0),
        (1, 1, 0, 1, 0, 0) => Some(9.0),
        (1, 1, 0, 1, 0, 1) => Some(7.7),
        (1, 1, 0, 1, 1, 0) => Some(7.5),
        (1, 1, 0, 1, 1, 1) => Some(6.2),
        (1, 1, 0, 1, 2, 0) => Some(6.1),
        (1, 1, 0, 1, 2, 1) => Some(5.3),
        (1, 1, 0, 2, 0, 0) => Some(7.7),
        (1, 1, 0, 2, 0, 1) => Some(6.6),
        (1, 1, 0, 2, 1, 0) => Some(6.8),
        (1, 1, 0, 2, 1, 1) => Some(5.9),
        (1, 1, 0, 2, 2, 0) => Some(5.2),
        (1, 1, 0, 2, 2, 1) => Some(3.0),
        (1, 1, 1, 0, 0, 0) => Some(8.9),
        (1, 1, 1, 0, 0, 1) => Some(7.8),
        (1, 1, 1, 0, 1, 0) => Some(7.6),
        (1, 1, 1, 0, 1, 1) => Some(6.7),
        (1, 1, 1, 0, 2, 0) => Some(6.2),
        (1, 1, 1, 0, 2, 1) => Some(5.8),
        (1, 1, 1, 1, 0, 0) => Some(7.4),
        (1, 1, 1, 1, 0, 1) => Some(5.9),
        (1, 1, 1, 1, 1, 0) => Some(5.7),
        (1, 1, 1, 1, 1, 1) => Some(5.7),
        (1, 1, 1, 1, 2, 0) => Some(4.7),
        (1, 1, 1, 1, 2, 1) => Some(2.3),
        (1, 1, 1, 2, 0, 0) => Some(6.1),
        (1, 1, 1, 2, 0, 1) => Some(5.2),
        (1, 1, 1, 2, 1, 0) => Some(5.7),
        (1, 1, 1, 2, 1, 1) => Some(2.9),
        (1, 1, 1, 2, 2, 0) => Some(2.4),
        (1, 1, 1, 2, 2, 1) => Some(1.6),
        (1, 1, 2, 0, 0, 1) => Some(7.1),
        (1, 1, 2, 0, 1, 1) => Some(5.9),
        (1, 1, 2, 0, 2, 1) => Some(3.0),
        (1, 1, 2, 1, 0, 1) => Some(5.8),
        (1, 1, 2, 1, 1, 1) => Some(2.6),
        (1, 1, 2, 1, 2, 1) => Some(1.5),
        (1, 1, 2, 2, 0, 1) => Some(2.3),
        (1, 1, 2, 2, 1, 1) => Some(1.3),
        (1, 1, 2, 2, 2, 1) => Some(0.6),
        (2, 0, 0, 0, 0, 0) => Some(9.3),
        (2, 0, 0, 0, 0, 1) => Some(8.7),
        (2, 0, 0, 0, 1, 0) => Some(8.6),
        (2, 0, 0, 0, 1, 1) => Some(7.2),
        (2, 0, 0, 0, 2, 0) => Some(7.5),
        (2, 0, 0, 0, 2, 1) => Some(5.8),
        (2, 0, 0, 1, 0, 0) => Some(8.6),
        (2, 0, 0, 1, 0, 1) => Some(7.4),
        (2, 0, 0, 1, 1, 0) => Some(7.4),
        (2, 0, 0, 1, 1, 1) => Some(6.1),
        (2, 0, 0, 1, 2, 0) => Some(5.6),
        (2, 0, 0, 1, 2, 1) => Some(3.4),
        (2, 0, 0, 2, 0, 0) => Some(7.0),
        (2, 0, 0, 2, 0, 1) => Some(5.4),
        (2, 0, 0, 2, 1, 0) => Some(5.2),
        (2, 0, 0, 2, 1, 1) => Some(4.0),
        (2, 0, 0, 2, 2, 0) => Some(4.0),
        (2, 0, 0, 2, 2, 1) => Some(2.2),
        (2, 0, 1, 0, 0, 0) => Some(8.5),
        (2, 0, 1, 0, 0, 1) => Some(7.5),
        (2, 0, 1, 0, 1, 0) => Some(7.4),
        (2, 0, 1, 0, 1, 1) => Some(5.5),
        (2, 0, 1, 0, 2, 0) => Some(6.2),
        (2, 0, 1, 0, 2, 1) => Some(5.1),
        (2, 0, 1, 1, 0, 0) => Some(7.2),
        (2, 0, 1, 1, 0, 1) => Some(5.7),
        (2, 0, 1, 1, 1, 0) => Some(5.5),
        (2, 0, 1, 1, 1, 1) => Some(4.1),
        (2, 0, 1, 1, 2, 0) => Some(4.6),
        (2, 0, 1, 1, 2, 1) => Some(1.9),
        (2, 0, 1, 2, 0, 0) => Some(5.3),
        (2, 0, 1, 2, 0, 1) => Some(3.6),
        (2, 0, 1, 2, 1, 0) => Some(3.4),
        (2, 0, 1, 2, 1, 1) => Some(1.9),
        (2, 0, 1, 2, 2, 0) => Some(1.9),
        (2, 0, 1, 2, 2, 1) => Some(0.8),
        (2, 0, 2, 0, 0, 1) => Some(6.4),
        (2, 0, 2, 0, 1, 1) => Some(5.1),
        (2, 0, 2, 0, 2, 1) => Some(2.0),
        (2, 0, 2, 1, 0, 1) => Some(4.7),
        (2, 0, 2, 1, 1, 1) => Some(2.1),
        (2, 0, 2, 1, 2, 1) => Some(1.1),
        (2, 0, 2, 2, 0, 1) => Some(2.4),
        (2, 0, 2, 2, 1, 1) => Some(0.9),
        (2, 0, 2, 2, 2, 1) => Some(0.4),
        (2, 1, 0, 0, 0, 0) => Some(8.8),
        (2, 1, 0, 0, 0, 1) => Some(7.5),
        (2, 1, 0, 0, 1, 0) => Some(7.3),
        (2, 1, 0, 0, 1, 1) => Some(5.3),
        (2, 1, 0, 0, 2, 0) => Some(6.0),
        (2, 1, 0, 0, 2, 1) => Some(5.0),
        (2, 1, 0, 1, 0, 0) => Some(7.3),
        (2, 1, 0, 1, 0, 1) => Some(5.5),
        (2, 1, 0, 1, 1, 0) => Some(5.9),
        (2, 1, 0, 1, 1, 1) => Some(4.0),
        (2, 1, 0, 1, 2, 0) => Some(4.1),
        (2, 1, 0, 1, 2, 1) => Some(2.0),
        (2, 1, 0, 2, 0, 0) => Some(5.4),
        (2, 1, 0, 2, 0, 1) => Some(4.3),
        (2, 1, 0, 2, 1, 0) => Some(4.5),
        (2, 1, 0, 2, 1, 1) => Some(2.2),
        (2, 1, 0, 2, 2, 0) => Some(2.0),
        (2, 1, 0, 2, 2, 1) => Some(1.1),
        (2, 1, 1, 0, 0, 0) => Some(7.5),
        (2, 1, 1, 0, 0, 1) => Some(5.5),
        (2, 1, 1, 0, 1, 0) => Some(5.8),
        (2, 1, 1, 0, 1, 1) => Some(4.5),
        (2, 1, 1, 0, 2, 0) => Some(4.0),
        (2, 1, 1, 0, 2, 1) => Some(2.1),
        (2, 1, 1, 1, 0, 0) => Some(6.1),
        (2, 1, 1, 1, 0, 1) => Some(5.1),
        (2, 1, 1, 1, 1, 0) => Some(4.8),
        (2, 1, 1, 1, 1, 1) => Some(1.8),
        (2, 1, 1, 1, 2, 0) => Some(2.0),
        (2, 1, 1, 1, 2, 1) => Some(0.9),
        (2, 1, 1, 2, 0, 0) => Some(4.6),
        (2, 1, 1, 2, 0, 1) => Some(1.8),
        (2, 1, 1, 2, 1, 0) => Some(1.7),
        (2, 1, 1, 2, 1, 1) => Some(0.7),
        (2, 1, 1, 2, 2, 0) => Some(0.8),
        (2, 1, 1, 2, 2, 1) => Some(0.2),
        (2, 1, 2, 0, 0, 1) => Some(5.3),
        (2, 1, 2, 0, 1, 1) => Some(2.4),
        (2, 1, 2, 0, 2, 1) => Some(1.4),
        (2, 1, 2, 1, 0, 1) => Some(2.4),
        (2, 1, 2, 1, 1, 1) => Some(1.2),
        (2, 1, 2, 1, 2, 1) => Some(0.5),
        (2, 1, 2, 2, 0, 1) => Some(1.0),
        (2, 1, 2, 2, 1, 1) => Some(0.3),
        (2, 1, 2, 2, 2, 1) => Some(0.1),
        _ => None,
    }
}
