use uncased::UncasedStr;

/// Named colors defined in <https://www.w3.org/TR/css-color-4/#named-colors>.
pub static NAMED_COLORS: phf::OrderedMap<&'static UncasedStr, [u8; 3]> = phf::phf_ordered_map! {
    UncasedStr::new("aliceblue") => [240, 248, 255],
    UncasedStr::new("antiquewhite") => [250, 235, 215],
    UncasedStr::new("aqua") => [0, 255, 255],
    UncasedStr::new("aquamarine") => [127, 255, 212],
    UncasedStr::new("azure") => [240, 255, 255],
    UncasedStr::new("beige") => [245, 245, 220],
    UncasedStr::new("bisque") => [255, 228, 196],
    UncasedStr::new("black") => [0, 0, 0],
    UncasedStr::new("blanchedalmond") => [255, 235, 205],
    UncasedStr::new("blue") => [0, 0, 255],
    UncasedStr::new("blueviolet") => [138, 43, 226],
    UncasedStr::new("brown") => [165, 42, 42],
    UncasedStr::new("burlywood") => [222, 184, 135],
    UncasedStr::new("cadetblue") => [95, 158, 160],
    UncasedStr::new("chartreuse") => [127, 255, 0],
    UncasedStr::new("chocolate") => [210, 105, 30],
    UncasedStr::new("coral") => [255, 127, 80],
    UncasedStr::new("cornflowerblue") => [100, 149, 237],
    UncasedStr::new("cornsilk") => [255, 248, 220],
    UncasedStr::new("crimson") => [220, 20, 60],
    UncasedStr::new("cyan") => [0, 255, 255],
    UncasedStr::new("darkblue") => [0, 0, 139],
    UncasedStr::new("darkcyan") => [0, 139, 139],
    UncasedStr::new("darkgoldenrod") => [184, 134, 11],
    UncasedStr::new("darkgray") => [169, 169, 169],
    UncasedStr::new("darkgreen") => [0, 100, 0],
    UncasedStr::new("darkgrey") => [169, 169, 169],
    UncasedStr::new("darkkhaki") => [189, 183, 107],
    UncasedStr::new("darkmagenta") => [139, 0, 139],
    UncasedStr::new("darkolivegreen") => [85, 107, 47],
    UncasedStr::new("darkorange") => [255, 140, 0],
    UncasedStr::new("darkorchid") => [153, 50, 204],
    UncasedStr::new("darkred") => [139, 0, 0],
    UncasedStr::new("darksalmon") => [233, 150, 122],
    UncasedStr::new("darkseagreen") => [143, 188, 143],
    UncasedStr::new("darkslateblue") => [72, 61, 139],
    UncasedStr::new("darkslategray") => [47, 79, 79],
    UncasedStr::new("darkslategrey") => [47, 79, 79],
    UncasedStr::new("darkturquoise") => [0, 206, 209],
    UncasedStr::new("darkviolet") => [148, 0, 211],
    UncasedStr::new("deeppink") => [255, 20, 147],
    UncasedStr::new("deepskyblue") => [0, 191, 255],
    UncasedStr::new("dimgray") => [105, 105, 105],
    UncasedStr::new("dimgrey") => [105, 105, 105],
    UncasedStr::new("dodgerblue") => [30, 144, 255],
    UncasedStr::new("firebrick") => [178, 34, 34],
    UncasedStr::new("floralwhite") => [255, 250, 240],
    UncasedStr::new("forestgreen") => [34, 139, 34],
    UncasedStr::new("fuchsia") => [255, 0, 255],
    UncasedStr::new("gainsboro") => [220, 220, 220],
    UncasedStr::new("ghostwhite") => [248, 248, 255],
    UncasedStr::new("gold") => [255, 215, 0],
    UncasedStr::new("goldenrod") => [218, 165, 32],
    UncasedStr::new("gray") => [128, 128, 128],
    UncasedStr::new("green") => [0, 128, 0],
    UncasedStr::new("greenyellow") => [173, 255, 47],
    UncasedStr::new("grey") => [128, 128, 128],
    UncasedStr::new("honeydew") => [240, 255, 240],
    UncasedStr::new("hotpink") => [255, 105, 180],
    UncasedStr::new("indianred") => [205, 92, 92],
    UncasedStr::new("indigo") => [75, 0, 130],
    UncasedStr::new("ivory") => [255, 255, 240],
    UncasedStr::new("khaki") => [240, 230, 140],
    UncasedStr::new("lavender") => [230, 230, 250],
    UncasedStr::new("lavenderblush") => [255, 240, 245],
    UncasedStr::new("lawngreen") => [124, 252, 0],
    UncasedStr::new("lemonchiffon") => [255, 250, 205],
    UncasedStr::new("lightblue") => [173, 216, 230],
    UncasedStr::new("lightcoral") => [240, 128, 128],
    UncasedStr::new("lightcyan") => [224, 255, 255],
    UncasedStr::new("lightgoldenrodyellow") => [250, 250, 210],
    UncasedStr::new("lightgray") => [211, 211, 211],
    UncasedStr::new("lightgreen") => [144, 238, 144],
    UncasedStr::new("lightgrey") => [211, 211, 211],
    UncasedStr::new("lightpink") => [255, 182, 193],
    UncasedStr::new("lightsalmon") => [255, 160, 122],
    UncasedStr::new("lightseagreen") => [32, 178, 170],
    UncasedStr::new("lightskyblue") => [135, 206, 250],
    UncasedStr::new("lightslategray") => [119, 136, 153],
    UncasedStr::new("lightslategrey") => [119, 136, 153],
    UncasedStr::new("lightsteelblue") => [176, 196, 222],
    UncasedStr::new("lightyellow") => [255, 255, 224],
    UncasedStr::new("lime") => [0, 255, 0],
    UncasedStr::new("limegreen") => [50, 205, 50],
    UncasedStr::new("linen") => [250, 240, 230],
    UncasedStr::new("magenta") => [255, 0, 255],
    UncasedStr::new("maroon") => [128, 0, 0],
    UncasedStr::new("mediumaquamarine") => [102, 205, 170],
    UncasedStr::new("mediumblue") => [0, 0, 205],
    UncasedStr::new("mediumorchid") => [186, 85, 211],
    UncasedStr::new("mediumpurple") => [147, 112, 219],
    UncasedStr::new("mediumseagreen") => [60, 179, 113],
    UncasedStr::new("mediumslateblue") => [123, 104, 238],
    UncasedStr::new("mediumspringgreen") => [0, 250, 154],
    UncasedStr::new("mediumturquoise") => [72, 209, 204],
    UncasedStr::new("mediumvioletred") => [199, 21, 133],
    UncasedStr::new("midnightblue") => [25, 25, 112],
    UncasedStr::new("mintcream") => [245, 255, 250],
    UncasedStr::new("mistyrose") => [255, 228, 225],
    UncasedStr::new("moccasin") => [255, 228, 181],
    UncasedStr::new("navajowhite") => [255, 222, 173],
    UncasedStr::new("navy") => [0, 0, 128],
    UncasedStr::new("oldlace") => [253, 245, 230],
    UncasedStr::new("olive") => [128, 128, 0],
    UncasedStr::new("olivedrab") => [107, 142, 35],
    UncasedStr::new("orange") => [255, 165, 0],
    UncasedStr::new("orangered") => [255, 69, 0],
    UncasedStr::new("orchid") => [218, 112, 214],
    UncasedStr::new("palegoldenrod") => [238, 232, 170],
    UncasedStr::new("palegreen") => [152, 251, 152],
    UncasedStr::new("paleturquoise") => [175, 238, 238],
    UncasedStr::new("palevioletred") => [219, 112, 147],
    UncasedStr::new("papayawhip") => [255, 239, 213],
    UncasedStr::new("peachpuff") => [255, 218, 185],
    UncasedStr::new("peru") => [205, 133, 63],
    UncasedStr::new("pink") => [255, 192, 203],
    UncasedStr::new("plum") => [221, 160, 221],
    UncasedStr::new("powderblue") => [176, 224, 230],
    UncasedStr::new("purple") => [128, 0, 128],
    UncasedStr::new("rebeccapurple") => [102, 51, 153],
    UncasedStr::new("red") => [255, 0, 0],
    UncasedStr::new("rosybrown") => [188, 143, 143],
    UncasedStr::new("royalblue") => [65, 105, 225],
    UncasedStr::new("saddlebrown") => [139, 69, 19],
    UncasedStr::new("salmon") => [250, 128, 114],
    UncasedStr::new("sandybrown") => [244, 164, 96],
    UncasedStr::new("seagreen") => [46, 139, 87],
    UncasedStr::new("seashell") => [255, 245, 238],
    UncasedStr::new("sienna") => [160, 82, 45],
    UncasedStr::new("silver") => [192, 192, 192],
    UncasedStr::new("skyblue") => [135, 206, 235],
    UncasedStr::new("slateblue") => [106, 90, 205],
    UncasedStr::new("slategray") => [112, 128, 144],
    UncasedStr::new("slategrey") => [112, 128, 144],
    UncasedStr::new("snow") => [255, 250, 250],
    UncasedStr::new("springgreen") => [0, 255, 127],
    UncasedStr::new("steelblue") => [70, 130, 180],
    UncasedStr::new("tan") => [210, 180, 140],
    UncasedStr::new("teal") => [0, 128, 128],
    UncasedStr::new("thistle") => [216, 191, 216],
    UncasedStr::new("tomato") => [255, 99, 71],
    UncasedStr::new("turquoise") => [64, 224, 208],
    UncasedStr::new("violet") => [238, 130, 238],
    UncasedStr::new("wheat") => [245, 222, 179],
    UncasedStr::new("white") => [255, 255, 255],
    UncasedStr::new("whitesmoke") => [245, 245, 245],
    UncasedStr::new("yellow") => [255, 255, 0],
    UncasedStr::new("yellowgreen") => [154, 205, 50],
};
