% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{iso-year-week-day-setters}
\alias{iso-year-week-day-setters}
\alias{set_year.clock_iso_year_week_day}
\alias{set_week.clock_iso_year_week_day}
\alias{set_day.clock_iso_year_week_day}
\alias{set_hour.clock_iso_year_week_day}
\alias{set_minute.clock_iso_year_week_day}
\alias{set_second.clock_iso_year_week_day}
\alias{set_millisecond.clock_iso_year_week_day}
\alias{set_microsecond.clock_iso_year_week_day}
\alias{set_nanosecond.clock_iso_year_week_day}
\title{Setters: iso-year-week-day}
\usage{
\method{set_year}{clock_iso_year_week_day}(x, value, ...)

\method{set_week}{clock_iso_year_week_day}(x, value, ...)

\method{set_day}{clock_iso_year_week_day}(x, value, ...)

\method{set_hour}{clock_iso_year_week_day}(x, value, ...)

\method{set_minute}{clock_iso_year_week_day}(x, value, ...)

\method{set_second}{clock_iso_year_week_day}(x, value, ...)

\method{set_millisecond}{clock_iso_year_week_day}(x, value, ...)

\method{set_microsecond}{clock_iso_year_week_day}(x, value, ...)

\method{set_nanosecond}{clock_iso_year_week_day}(x, value, ...)
}
\arguments{
\item{x}{\verb{[clock_iso_year_week_day]}

A iso-year-week-day vector.}

\item{value}{\verb{[integer / "last"]}

The value to set the component to.

For \code{set_week()}, this can also be \code{"last"} to adjust to the last
week of the current ISO year.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} with the component set.
}
\description{
These are iso-year-week-day methods for the
\link[=clock-setters]{setter generics}.
\itemize{
\item \code{set_year()} sets the ISO year.
\item \code{set_week()} sets the ISO week of the year. Valid values are in the range
of \verb{[1, 53]}.
\item \code{set_day()} sets the day of the week. Valid values are in the range of
\verb{[1, 7]}, with 1 = Monday, and 7 = Sunday.
\item There are sub-daily setters for setting more precise components.
}
}
\examples{
# Year precision vector
x <- iso_year_week_day(2019:2023)

# Promote to week precision by setting the week
# (Note that some ISO weeks have 52 weeks, and others have 53)
x <- set_week(x, "last")
x

# Set to an invalid week
invalid <- set_week(x, 53)
invalid

# Here are the invalid ones (they only have 52 weeks)
invalid[invalid_detect(invalid)]

# Resolve the invalid dates by choosing the previous/next valid moment
invalid_resolve(invalid, invalid = "previous")
invalid_resolve(invalid, invalid = "next")
}
