% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date-and-date-time-rounding}
\alias{date-and-date-time-rounding}
\alias{date_floor}
\alias{date_ceiling}
\alias{date_round}
\title{Date and date-time rounding}
\usage{
date_floor(x, precision, ..., n = 1L, origin = NULL)

date_ceiling(x, precision, ..., n = 1L, origin = NULL)

date_round(x, precision, ..., n = 1L, origin = NULL)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date or date-time vector.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the input used.}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}

\item{origin}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1) / NULL]}

An origin to start counting from. The default \code{origin} is
midnight on 1970-01-01 in the time zone of \code{x}.}
}
\value{
\code{x} rounded to the specified \code{precision}.
}
\description{
\itemize{
\item \code{date_floor()} rounds a date or date-time down to a multiple of
the specified \code{precision}.
\item \code{date_ceiling()} rounds a date or date-time up to a multiple of
the specified \code{precision}.
\item \code{date_round()} rounds up or down depending on what is closer,
rounding up on ties.
}

There are separate help pages for rounding dates and date-times:
\itemize{
\item \link[=date-rounding]{dates (Date)}
\item \link[=posixt-rounding]{date-times (POSIXct/POSIXlt)}
}

These functions round the underlying duration itself, relative to an
\code{origin}. For example, rounding to 15 hours will construct groups of
15 hours, starting from \code{origin}, which defaults to a naive time of
1970-01-01 00:00:00.

If you want to group by components, such as "day of the month", see
\code{\link[=date_group]{date_group()}}.
}
\examples{
# See the type specific documentation for more examples

x <- as.Date("2019-03-31") + 0:5
x

# Flooring by 2 days, note that this is not tied to the current month,
# and instead counts from the specified `origin`.
date_floor(x, "day", n = 2)
}
