Contributing
============
We gratefully accept bug reports and contributions from the community. All PRs are reviewed by the project team / community, and may need some modifications to
be accepted.

Most contributions in this repository will be associated with [Mbed TLS](https://github.com/Mbed-TLS/mbedtls/blob/development/CONTRIBUTING.md) or TF-PSA-Crypto. Please consult their respective contribution guidelines for more information.

What can I contribute here?
---------------------------

This repository is intended to contain files that are shared between multiple maintained branches of Mbed TLS and TF-PSA-Crypto. The exact policies are not yet written down. Please contribute in this repository if you wish to update one of the files that are present here.

License and Copyright
---------------------

Unless specifically indicated otherwise in a file, Mbed TLS framework files are provided under a dual [Apache-2.0](https://spdx.org/licenses/Apache-2.0.html) OR [GPL-2.0-or-later](https://spdx.org/licenses/GPL-2.0-or-later.html) license. See the [LICENSE](LICENSE) file for the full text of these licenses. This means that users may choose which of these licenses they take the code under.

Contributors must accept that their contributions are made under both the Apache-2.0 AND [GPL-2.0-or-later](https://spdx.org/licenses/GPL-2.0-or-later.html) licenses.

All new files should include the standard SPDX license identifier where possible, i.e. "SPDX-License-Identifier: Apache-2.0 OR GPL-2.0-or-later".

The copyright on contributions is retained by the original authors of the code. Where possible for new files, this should be noted in a comment at the top of the file in the form: "Copyright The Mbed TLS Contributors".

When contributing code to us, the committer and all authors are required to make the submission under the terms of the [Developer Certificate of Origin](dco.txt), confirming that the code submitted can (legally) become part of the project, and is submitted under both the Apache-2.0 AND GPL-2.0-or-later licenses.

This is done by including the standard Git `Signed-off-by:` line in every commit message. If more than one person contributed to the commit, they should also add their own `Signed-off-by:` line.
