/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "slot.h"
#include "typemanager.h"
#include "datatype.h"
#include "slotdescription.h"

using namespace WorKflow;

Command* Slot::command()
{
  return m_command;
}

QString Slot::id()
{
  return m_id;
}

QString Slot::name()
{
  return m_name;
}

QString Slot::description()
{
  return m_description;
}

Datatype* Slot::type()
{
  return m_type;
}

QStringList Slot::typeIds()
{
  return m_typeIds;
}

Slot::Slot(Command* command, SlotDescription* desc)
  : m_command(command), m_problem(NoProblem)
{
  m_id = desc->id();
  m_name = desc->name();
  m_description = desc->description();
}

Slot::~Slot()
{
}

void Slot::setTypeIds(const QStringList& typeIds)
{
  m_typeIds = typeIds;
  resetType();
}

void Slot::setType(const QString& id)
{
  // TODO: check if m_typeIds contains id (or some derived type)
  m_type = TypeManager::self()->find(id);
  emit guiUpdateNeeded();
}

QString Slot::typeId()
{
  if (m_type)
    return m_type->id();
  return "";
}

void Slot::setProblem(Problem problem)
{
  m_problem = problem;
  emit guiUpdateNeeded();
}

Slot::Problem Slot::problem() const
{
  return m_problem;
}

void Slot::resetType()
{
  m_problem = NoProblem;
  setType(m_typeIds.first());
}

#include "slot.moc"
