/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "serviceinfo.h"
#include "document.h"
#include "service.h"
#include "command.h"

using namespace WorKflow;

ServiceInfo::ServiceInfo(Document* doc)
  : m_document(doc)
{
}

ServiceInfo::~ServiceInfo()
{
}

ServiceInfo::List ServiceInfo::query(int position, const QString& type)
{
  List result;

  for (int i = 0; i != position; ++i) {
    Command* cmd = m_document->commandAt(i);
    List services = cmd->services();
    for (List::ConstIterator i = services.begin(); i != services.end(); ++i) {
      if ((*i)->type() == type)
        result.append(*i);
    }
  }

  return result;
}

#include "serviceinfo.moc"
