/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <dcopclient.h>
#include <kdebug.h>

// WorKflow includes
#include "applicationmanager.h"
#include "application.h"
#include "applicationfactory.h"
#include "applicationdescription.h"
#include "serviceinfo.h"
#include "runapplicationservice.h"
#include "document.h"

using namespace WorKflow;

ApplicationManager::Static* ApplicationManager::s = 0;

class ApplicationManager::Static
{
public:
  QMap<QString, ApplicationDescription*> apps;
  QString mainAppId;
  QString mainAppDcopName;
  Application* mainApp;
};

class ApplicationManager::Private
{
public:
  Instances runningAt(int beforeRow);

  Document* document;
  Instances running;
};

ApplicationManager::Instances ApplicationManager::Private::runningAt(int beforeRow)
{
  if (beforeRow == -1)
    return Instances();

  Instances running;

  ServiceInfo info(document);
  ServiceInfo::List list = info.query(beforeRow, "run_application");

  for (ServiceInfo::List::ConstIterator i = list.begin(); i != list.end(); ++i) {
    RunApplicationService* service = static_cast<RunApplicationService*>(*i);
    running.append(service->instance());
  }

  return running;
}

ApplicationManager::ApplicationManager(Document* parent)
  : QObject(parent)
{
  d = new Private;
  d->document = parent;

  DCOPClient* client = kapp->dcopClient();
  client->setNotifications(true);
  connect(client, SIGNAL(applicationRegistered(const QCString&)), this, SLOT(slotNewApplication(const QCString&)));
  connect(client, SIGNAL(applicationRemoved(const QCString&)), this, SLOT(slotApplicationExit(const QCString&)));
}

ApplicationManager::~ApplicationManager()
{
  delete d;
}

ApplicationManager::Static* ApplicationManager::staticPart()
{
  if (!s) {
    s = new Static;
    s->mainApp = 0;
  }
  return s;
}

void ApplicationManager::setMainApplication(const QString& id, const QString& dcopName)
{
  staticPart()->mainAppId = id;
  staticPart()->mainAppDcopName = dcopName;
}

Application* ApplicationManager::mainApplication()
{
  if (!staticPart()->mainApp) {
    ApplicationDescription* app = find(staticPart()->mainAppId);
    if (!app) {
      kdWarning() << "unknown main application ID " << staticPart()->mainAppId << endl;
    } else {
      staticPart()->mainApp = app->factory()->create(staticPart()->mainAppDcopName);
    }
  }

  return staticPart()->mainApp;
}

void ApplicationManager::registerApplication(ApplicationDescription* app)
{
  staticPart()->apps[app->id()] = app;
}

void ApplicationManager::unregisterApplication(ApplicationDescription* app)
{
  staticPart()->apps.erase(app->id());
}

ApplicationDescription* ApplicationManager::find(const QString& id)
{
  if (staticPart()->apps.contains(id))
    return staticPart()->apps[id];
  return 0;
}

ApplicationManager::List ApplicationManager::query(bool unique)
{
  List result;

  for (QMap<QString, ApplicationDescription*>::ConstIterator i = staticPart()->apps.begin(); i != staticPart()->apps.end(); ++i)
    if (unique && (*i)->isUnique() || !unique)
      result.append(i.data());
  return result;
}

ApplicationManager::Instances ApplicationManager::running(bool known, bool unique, int beforeRow)
{
  Instances result;
  if (known) {
    for (QMap<QString, ApplicationDescription*>::ConstIterator i = staticPart()->apps.begin(); i != staticPart()->apps.end(); ++i)
      if (unique && i.data()->isUnique() || !unique)
        result += i.data()->runningInstances();
  } else {
    for (Instances::ConstIterator i = d->running.begin(); i != d->running.end(); ++i)
      if (unique && (*i)->isUnique() || !unique)
        if ((*i)->isRunning())
          result.append(*i);
  }
  return result + d->runningAt(beforeRow);
}

Application* ApplicationManager::run(ApplicationDescription* app)
{
//   KProcess proc;
  
}

void ApplicationManager::terminate(Application* instance)
{
  instance->terminate();
}

void ApplicationManager::slotNewApplication(const QCString& name)
{
}

void ApplicationManager::slotApplicationExit(const QCString& name)
{
}

ApplicationManager::Instances ApplicationManager::running()
{
  // TODO: think about that a little ... That's obviously not enough :)
  Instances result;
  Application* app = mainApplication();
  if (app)
    result.append(app);
  return result;
}

Application* ApplicationManager::findRunning(const QString& id)
{
  Instances instances = running();
  for (Instances::ConstIterator i = instances.begin(); i != instances.end(); ++i) {
    if ((*i)->id() == id)
      return *i;
  }
  return 0;
}

#include "applicationmanager.moc"
