/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kfileitem.h>
#include <klocale.h>

// command includes
#include "listfoldercontentscommand.h"
#include "listfoldercontentswidget.h"

using namespace WorKflow;

ListFolderContentsCommand::ListFolderContentsCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  ListFolderContentsWidget* w = new ListFolderContentsWidget(this);
  setWidget(w);
}

ListFolderContentsCommand::~ListFolderContentsCommand()
{
}

void ListFolderContentsCommand::execute()
{
  bool recursive = value("recursive").nextBoolean();

  QStringList dirs = value("input").asStringList();
  m_output.clear();

  int count = dirs.count();
  int num = 1;
  for (QStringList::ConstIterator i = dirs.begin(); i != dirs.end(); ++i, ++num) {
    m_currentDir = KURL(*i);

    emit progress(double(num) / double(count), i18n("Listing content of folder \"%1\"").arg(m_currentDir.url()));

    KIO::ListJob* job;
    if (recursive)
      job = KIO::listRecursive(m_currentDir, false);
    else
      job = KIO::listDir(m_currentDir, false);

    connect(job, SIGNAL(entries(KIO::Job*, const KIO::UDSEntryList&)),
            SLOT(listEntries(KIO::Job*, const KIO::UDSEntryList&)));

    waitFor(job, SIGNAL(result(KIO::Job*)));
  }

  setResult("output", Value::stringList("org.kde.public.fileorfolder", m_output));
}

void ListFolderContentsCommand::listEntries(KIO::Job*, const KIO::UDSEntryList& list)
{
  for (KIO::UDSEntryListConstIterator i = list.begin(); i != list.end(); ++i) {
    KFileItem file(*i, m_currentDir, true, true);
    m_output << file.url().url();
  }
}

#include "listfoldercontentscommand.moc"
