/***************************************************************************
                          kpropdlg.cpp  -  description
                             -------------------
    begin                : ven avr 23 18:58:17 CEST 1999

    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>

#include <qpixmap.h>
#include <qlayout.h>
#include <qfileinfo.h>
#include <qdatetime.h>

#include "kpropdlg.h"
#include "kfilecoder.h"
#include "filelib.h"

// ===========================================================================================================================
KPropDlg::KPropDlg(char *szArchivePath, int nNbFiles, int nAlgoUsed, QWidget* parent, const char* name):QDialog(parent, name, true)
{
	setCaption(i18n("Archive Properties"));
	
	QGridLayout *gbox;
	gbox = new QGridLayout (this, 8, 1, 0, 10);
	gbox -> setMargin(15);

	QLabel *labelText;
	QString strText;
	QFileInfo fi(szArchivePath);
	
	// Name of file
	labelText = new QLabel(this);
	strText.sprintf(i18n("Name:\t\t\t%s"), fi.fileName().data());
  labelText->setText(strText);
	gbox -> addWidget (labelText, 0, 0);

	// Path of file
	labelText = new QLabel(this);
	strText.sprintf(i18n("Path:\t\t\t%s"), fi.dirPath().data());
  labelText->setText(strText);
	gbox -> addWidget (labelText, 1, 0);

	// Size of file
	labelText = new QLabel(this);
	strText.sprintf(i18n("Size:\t\t\t%ld bytes = %s"), fi.size(), formatSize((QWORD)fi.size()).data());
  labelText->setText(strText);
	gbox -> addWidget (labelText, 2, 0);

	// Number of files
	labelText = new QLabel(this);
	strText.sprintf(i18n("Number of files:\t\t%ld files"), nNbFiles);
  labelText->setText(strText);
	gbox -> addWidget (labelText, 3, 0);

	// Algorithm used
	labelText = new QLabel(this);
	strText.sprintf(i18n("Algorithm used:\t\t%s (%s)"), g_algo[nAlgoUsed].szName, g_algo[nAlgoUsed].szDescription);
  labelText->setText(strText);
	gbox -> addWidget (labelText, 4, 0);
	
	// Last read date
	labelText = new QLabel(this);
	strText.sprintf(i18n("Last read date:\t\t%s"), fi.lastRead().toString().data());
  labelText->setText(strText);
	gbox -> addWidget (labelText, 5, 0);
	
	// Last write date
	labelText = new QLabel(this);
	strText.sprintf(i18n("Last write date:\t\t%s"), fi.lastModified().toString().data());
  labelText->setText(strText);
	gbox -> addWidget (labelText, 6, 0);
	
  // close
  m_btnClose = new QPushButton(this,"m_btnClose");
  m_btnClose->setText(i18n("&Close"));
	gbox -> addWidget (m_btnClose, 7, 0);
	
	connect(m_btnClose,SIGNAL(clicked()),this,SLOT(slotClose()));
}

// ===========================================================================================================================
KPropDlg::~KPropDlg()
{
}

// ===========================================================================================================================
void KPropDlg::slotClose()
{	this->done(0);
}










