/*
 * THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 *
 * Copyright (C) 2005 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */


#include "config.h"
#include "SVGElementFactory.h"
#include "SVGNames.h"
#include "Page.h"
#include "Settings.h"
#include "SVGAElement.h"
#include "SVGCircleElement.h"
#include "SVGClipPathElement.h"
#include "SVGCursorElement.h"
#include "SVGDefsElement.h"
#include "SVGDescElement.h"
#include "SVGEllipseElement.h"
#include "SVGGElement.h"
#include "SVGImageElement.h"
#include "SVGLineElement.h"
#include "SVGLinearGradientElement.h"
#include "SVGMarkerElement.h"
#include "SVGMaskElement.h"
#include "SVGMetadataElement.h"
#include "SVGMPathElement.h"
#include "SVGPathElement.h"
#include "SVGPatternElement.h"
#include "SVGPolygonElement.h"
#include "SVGPolylineElement.h"
#include "SVGRadialGradientElement.h"
#include "SVGRectElement.h"
#include "SVGScriptElement.h"
#include "SVGSetElement.h"
#include "SVGStopElement.h"
#include "SVGStyleElement.h"
#include "SVGSVGElement.h"
#include "SVGSwitchElement.h"
#include "SVGSymbolElement.h"
#include "SVGTextElement.h"
#include "SVGTitleElement.h"
#include "SVGTRefElement.h"
#include "SVGTSpanElement.h"
#include "SVGUseElement.h"
#include "SVGViewElement.h"
#include <wtf/HashMap.h>

using namespace WebCore;
using namespace WebCore::SVGNames;

typedef SVGElement *(*ConstructorFunc)(Document *doc, bool createdByParser);
typedef WTF::HashMap<AtomicStringImpl*, ConstructorFunc> FunctionMap;

static FunctionMap *gFunctionMap = 0;

namespace WebCore {

#if ENABLE(SVG)
SVGElement *aConstructor(Document *doc, bool createdByParser)
{
    return new SVGAElement(aTag, doc);
}

SVGElement *circleConstructor(Document *doc, bool createdByParser)
{
    return new SVGCircleElement(circleTag, doc);
}

SVGElement *clipPathConstructor(Document *doc, bool createdByParser)
{
    return new SVGClipPathElement(clipPathTag, doc);
}

SVGElement *cursorConstructor(Document *doc, bool createdByParser)
{
    return new SVGCursorElement(cursorTag, doc);
}

SVGElement *defsConstructor(Document *doc, bool createdByParser)
{
    return new SVGDefsElement(defsTag, doc);
}

SVGElement *descConstructor(Document *doc, bool createdByParser)
{
    return new SVGDescElement(descTag, doc);
}

SVGElement *ellipseConstructor(Document *doc, bool createdByParser)
{
    return new SVGEllipseElement(ellipseTag, doc);
}

SVGElement *gConstructor(Document *doc, bool createdByParser)
{
    return new SVGGElement(gTag, doc);
}

SVGElement *imageConstructor(Document *doc, bool createdByParser)
{
    return new SVGImageElement(imageTag, doc);
}

SVGElement *lineConstructor(Document *doc, bool createdByParser)
{
    return new SVGLineElement(lineTag, doc);
}

SVGElement *linearGradientConstructor(Document *doc, bool createdByParser)
{
    return new SVGLinearGradientElement(linearGradientTag, doc);
}

SVGElement *markerConstructor(Document *doc, bool createdByParser)
{
    return new SVGMarkerElement(markerTag, doc);
}

SVGElement *maskConstructor(Document *doc, bool createdByParser)
{
    return new SVGMaskElement(maskTag, doc);
}

SVGElement *metadataConstructor(Document *doc, bool createdByParser)
{
    return new SVGMetadataElement(metadataTag, doc);
}

SVGElement *mpathConstructor(Document *doc, bool createdByParser)
{
    return new SVGMPathElement(mpathTag, doc);
}

SVGElement *pathConstructor(Document *doc, bool createdByParser)
{
    return new SVGPathElement(pathTag, doc);
}

SVGElement *patternConstructor(Document *doc, bool createdByParser)
{
    return new SVGPatternElement(patternTag, doc);
}

SVGElement *polygonConstructor(Document *doc, bool createdByParser)
{
    return new SVGPolygonElement(polygonTag, doc);
}

SVGElement *polylineConstructor(Document *doc, bool createdByParser)
{
    return new SVGPolylineElement(polylineTag, doc);
}

SVGElement *radialGradientConstructor(Document *doc, bool createdByParser)
{
    return new SVGRadialGradientElement(radialGradientTag, doc);
}

SVGElement *rectConstructor(Document *doc, bool createdByParser)
{
    return new SVGRectElement(rectTag, doc);
}

SVGElement *scriptConstructor(Document *doc, bool createdByParser)
{
    return new SVGScriptElement(scriptTag, doc);
}

SVGElement *setConstructor(Document *doc, bool createdByParser)
{
    return new SVGSetElement(setTag, doc);
}

SVGElement *stopConstructor(Document *doc, bool createdByParser)
{
    return new SVGStopElement(stopTag, doc);
}

SVGElement *styleConstructor(Document *doc, bool createdByParser)
{
    return new SVGStyleElement(styleTag, doc);
}

SVGElement *svgConstructor(Document *doc, bool createdByParser)
{
    return new SVGSVGElement(svgTag, doc);
}

SVGElement *switchConstructor(Document *doc, bool createdByParser)
{
    return new SVGSwitchElement(switchTag, doc);
}

SVGElement *symbolConstructor(Document *doc, bool createdByParser)
{
    return new SVGSymbolElement(symbolTag, doc);
}

SVGElement *textConstructor(Document *doc, bool createdByParser)
{
    return new SVGTextElement(textTag, doc);
}

SVGElement *titleConstructor(Document *doc, bool createdByParser)
{
    return new SVGTitleElement(titleTag, doc);
}

SVGElement *trefConstructor(Document *doc, bool createdByParser)
{
    return new SVGTRefElement(trefTag, doc);
}

SVGElement *tspanConstructor(Document *doc, bool createdByParser)
{
    return new SVGTSpanElement(tspanTag, doc);
}

SVGElement *useConstructor(Document *doc, bool createdByParser)
{
    return new SVGUseElement(useTag, doc);
}

SVGElement *viewConstructor(Document *doc, bool createdByParser)
{
    return new SVGViewElement(viewTag, doc);
}

#endif
#if ENABLE(SVG)
static inline void createFunctionMapIfNecessary()
{
    if (gFunctionMap)
        return;
    // Create the table.
    gFunctionMap = new FunctionMap;
    
    // Populate it with constructor functions.
    gFunctionMap->set(aTag.localName().impl(), aConstructor);
    gFunctionMap->set(circleTag.localName().impl(), circleConstructor);
    gFunctionMap->set(clipPathTag.localName().impl(), clipPathConstructor);
    gFunctionMap->set(cursorTag.localName().impl(), cursorConstructor);
    gFunctionMap->set(defsTag.localName().impl(), defsConstructor);
    gFunctionMap->set(descTag.localName().impl(), descConstructor);
    gFunctionMap->set(ellipseTag.localName().impl(), ellipseConstructor);
    gFunctionMap->set(gTag.localName().impl(), gConstructor);
    gFunctionMap->set(imageTag.localName().impl(), imageConstructor);
    gFunctionMap->set(lineTag.localName().impl(), lineConstructor);
    gFunctionMap->set(linearGradientTag.localName().impl(), linearGradientConstructor);
    gFunctionMap->set(markerTag.localName().impl(), markerConstructor);
    gFunctionMap->set(maskTag.localName().impl(), maskConstructor);
    gFunctionMap->set(metadataTag.localName().impl(), metadataConstructor);
    gFunctionMap->set(mpathTag.localName().impl(), mpathConstructor);
    gFunctionMap->set(pathTag.localName().impl(), pathConstructor);
    gFunctionMap->set(patternTag.localName().impl(), patternConstructor);
    gFunctionMap->set(polygonTag.localName().impl(), polygonConstructor);
    gFunctionMap->set(polylineTag.localName().impl(), polylineConstructor);
    gFunctionMap->set(radialGradientTag.localName().impl(), radialGradientConstructor);
    gFunctionMap->set(rectTag.localName().impl(), rectConstructor);
    gFunctionMap->set(scriptTag.localName().impl(), scriptConstructor);
    gFunctionMap->set(setTag.localName().impl(), setConstructor);
    gFunctionMap->set(stopTag.localName().impl(), stopConstructor);
    gFunctionMap->set(styleTag.localName().impl(), styleConstructor);
    gFunctionMap->set(svgTag.localName().impl(), svgConstructor);
    gFunctionMap->set(switchTag.localName().impl(), switchConstructor);
    gFunctionMap->set(symbolTag.localName().impl(), symbolConstructor);
    gFunctionMap->set(textTag.localName().impl(), textConstructor);
    gFunctionMap->set(titleTag.localName().impl(), titleConstructor);
    gFunctionMap->set(trefTag.localName().impl(), trefConstructor);
    gFunctionMap->set(tspanTag.localName().impl(), tspanConstructor);
    gFunctionMap->set(useTag.localName().impl(), useConstructor);
    gFunctionMap->set(viewTag.localName().impl(), viewConstructor);
}
#endif

SVGElement *SVGElementFactory::createSVGElement(const QualifiedName& qName, Document* doc, bool createdByParser)
{
#if ENABLE(SVG)
    // Don't make elements without a document
    if (!doc)
        return 0;
    
    Settings* settings = doc->settings();
    if (settings && settings->usesDashboardBackwardCompatibilityMode())
        return 0;

    createFunctionMapIfNecessary();
    ConstructorFunc func = gFunctionMap->get(qName.localName().impl());
    if (func)
        return func(doc, createdByParser);
    
    return new SVGElement(qName, doc);
#else
    return 0;
#endif
}

} // namespace

