#include "simple-view.h"

SimpleView::SimpleView()
{
	set_title("Simple View");
	set_default_size(250, 0);

	// Get the default client
	client = GConf::Client::get_default();
	
	// Retrieve string, if previously set.
	String s = client->get_string("/extra/test/directory/key");
	if (s.null())
		s.assign("<unset>");

	label = new Gtk::Label(s);
	add(*label);
	label->show();

	// Tell GConf::Client that we're interested in the given directory. This means
	// GConfClient will receive notification of changes to this directory, and
	// cache keys under this directory. We use PRELOAD_NONE to avoid loading all
	// config keys on startup.
	client->add_dir("/extra/test/directory", GConf::Client::PRELOAD_NONE);

 	// Notification slot for key changes. Uses a smart pointer to unreference the slot.
	// Remmeber, a slot not connected to a signal must be explicitly unreferecned.
	notify_slot = slot(this, &SimpleView::on_key_changed);

	// Note that notify_id will be 0 if there was an error, so we handle that in the destructor.
	notify_id = client->notify_add("/extra/test/directory/key", notify_slot);
}

SimpleView::~SimpleView()
{
	if (notify_id)
		client->notify_remove(notify_id);
}

void 
SimpleView::on_key_changed(unsigned int /*cnxn_id*/, const GConf::Entry& entry)
{
	GConf::Value value = entry.get_value();
	
	if (!value.is_set())
	{
		label->set_text("<unset>");
	}
	else if (value.get_type() == GConf::VALUE_STRING)
	{
		label->set_text(value.get_string());
	}
	else
	{
		label->set_text("<wrong type>");
	}
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	SimpleView window;
	window.sig_destroy().connect(slot(&Inti::Main::quit));
	window.show();

	run();
	return 0;
}

