/******************************************************************************/
/* gdk1_type_defines.h - GDK1 specific type definitions                       */
/******************************************************************************/
/* Smooth Theme Engine                                                        */
/* Copyright (C) 2002-2004 Andrew Johnson                                     */
/*                                                                            */
/* This library is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU Lesser General Public                 */
/* License as published by the Free Software Foundation; either               */
/* version 2.1 of the License, or (at your option) any later version.         */
/*                                                                            */
/* This library is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          */
/* Lesser General Public License for more details.                            */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public           */
/* License along with this library; if not, write to the Free Software        */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */
/*                                                                            */
/* Author(s): Andrew Johnson <ajgenius@ajgenius.us>                           */
/******************************************************************************/
#ifndef GDK1_TYPE_DEFINES_H
#define GDK1_TYPE_DEFINES_H

#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>

#include <interfaces/shared/gdk/gdk_type_defines.h>

#define SMOOTHSTRINGS	1
#define SMOOTHINTS	1
#define SMOOTHBOOL	1
#define SMOOTHPOINT	1
#define SMOOTHRECTANGLE	1

/* Declare Shape/Image Structs */
#define SMOOTHIMAGES	1
typedef GdkPixbuf* SmoothImageBuffer;
typedef SmoothGDKImage SmoothImage;

#define SMOOTHCOLOR	1
typedef SmoothGDKColor SmoothColor;

#define SMOOTHBRUSHTYPE	1
typedef SmoothGDKBrushType SmoothBrushType;
  
#define SMOOTHLINEPROPERTIES	1
typedef SmoothGDKLineStyle SmoothLineStyle;
typedef SmoothGDKLineCap SmoothLineCap;
typedef SmoothGDKLineJoin SmoothLineJoin;

#endif /* GDK1_TYPE_DEFINES_H */
