#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Solstice
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250930.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='solstice'
GAME_NAME='Solstice'

ARCHIVE_BASE_0_NAME='setup_solstice_1.4.13_(33035).exe'
ARCHIVE_BASE_0_MD5='4e5cd3affaf723a263ad828d49920e51'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='360000'
ARCHIVE_BASE_0_VERSION='1.4.13-gog33035'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/solstice'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
gog.gml.dll
solstice.exe'
## TODO: Check if the GOG Galaxy library is required.
CONTENT_GAME0_BIN_FILES='
galaxy.dll'
CONTENT_GAME_DATA_FILES='
data.win
*.ogg'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Solstice'

APP_MAIN_EXE='solstice.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
