#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Call of the Sea
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241105.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='call-of-the-sea'
GAME_NAME='Call of the Sea'

ARCHIVE_BASE_0_NAME='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714).exe'
ARCHIVE_BASE_0_MD5='130e503109c0da8323eabbf07f939b40'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='eefc9fe7a9e45a0b9f84cc9f9f9ea1ab'
ARCHIVE_BASE_0_PART2_NAME='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='c2d114836a23671a0483ad1ad97c2912'
ARCHIVE_BASE_0_PART3_NAME='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='1b4c240b663134295b223c8c62d3cbf0'
ARCHIVE_BASE_0_SIZE='40000000'
ARCHIVE_BASE_0_VERSION='1.5.15.0-gog48714'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/call_of_the_sea'

UNREALENGINE4_NAME='cots'

CONTENT_PATH_DEFAULT='.'

HUGE_FILES_DATA="
${UNREALENGINE4_NAME}/content/paks/${UNREALENGINE4_NAME}-windowsnoeditor.pak"

APP_MAIN_EXE="${UNREALENGINE4_NAME}/binaries/win64/bluecode-win64-shipping.exe"
## The --name=101 wrestool option, default for UE4 games, should not be used here
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
