/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (C) 2024-2025 Haylen Chu <heylenay@outlook.com>
 */

#ifndef _DT_BINDINGS_SPACEMIT_CCU_H_
#define _DT_BINDINGS_SPACEMIT_CCU_H_

/* APBS (PLL) clocks */
#define CLK_PLL1		0
#define CLK_PLL2		1
#define CLK_PLL3		2
#define CLK_PLL1_D2		3
#define CLK_PLL1_D3		4
#define CLK_PLL1_D4		5
#define CLK_PLL1_D5		6
#define CLK_PLL1_D6		7
#define CLK_PLL1_D7		8
#define CLK_PLL1_D8		9
#define CLK_PLL1_D11		10
#define CLK_PLL1_D13		11
#define CLK_PLL1_D23		12
#define CLK_PLL1_D64		13
#define CLK_PLL1_D10_AUD	14
#define CLK_PLL1_D100_AUD	15
#define CLK_PLL2_D1		16
#define CLK_PLL2_D2		17
#define CLK_PLL2_D3		18
#define CLK_PLL2_D4		19
#define CLK_PLL2_D5		20
#define CLK_PLL2_D6		21
#define CLK_PLL2_D7		22
#define CLK_PLL2_D8		23
#define CLK_PLL3_D1		24
#define CLK_PLL3_D2		25
#define CLK_PLL3_D3		26
#define CLK_PLL3_D4		27
#define CLK_PLL3_D5		28
#define CLK_PLL3_D6		29
#define CLK_PLL3_D7		30
#define CLK_PLL3_D8		31
#define CLK_PLL3_80		32
#define CLK_PLL3_40		33
#define CLK_PLL3_20		34

/* MPMU clocks */
#define CLK_PLL1_307P2		0
#define CLK_PLL1_76P8		1
#define CLK_PLL1_61P44		2
#define CLK_PLL1_153P6		3
#define CLK_PLL1_102P4		4
#define CLK_PLL1_51P2		5
#define CLK_PLL1_51P2_AP	6
#define CLK_PLL1_57P6		7
#define CLK_PLL1_25P6		8
#define CLK_PLL1_12P8		9
#define CLK_PLL1_12P8_WDT	10
#define CLK_PLL1_6P4		11
#define CLK_PLL1_3P2		12
#define CLK_PLL1_1P6		13
#define CLK_PLL1_0P8		14
#define CLK_PLL1_409P6		15
#define CLK_PLL1_204P8		16
#define CLK_PLL1_491		17
#define CLK_PLL1_245P76		18
#define CLK_PLL1_614		19
#define CLK_PLL1_47P26		20
#define CLK_PLL1_31P5		21
#define CLK_PLL1_819		22
#define CLK_PLL1_1228		23
#define CLK_SLOW_UART		24
#define CLK_SLOW_UART1		25
#define CLK_SLOW_UART2		26
#define CLK_WDT			27
#define CLK_RIPC		28
#define CLK_I2S_SYSCLK		29
#define CLK_I2S_BCLK		30
#define CLK_APB			31
#define CLK_WDT_BUS		32

/* MPMU resets */
#define RESET_WDT		0

/* APBC clocks */
#define CLK_UART0		0
#define CLK_UART2		1
#define CLK_UART3		2
#define CLK_UART4		3
#define CLK_UART5		4
#define CLK_UART6		5
#define CLK_UART7		6
#define CLK_UART8		7
#define CLK_UART9		8
#define CLK_GPIO		9
#define CLK_PWM0		10
#define CLK_PWM1		11
#define CLK_PWM2		12
#define CLK_PWM3		13
#define CLK_PWM4		14
#define CLK_PWM5		15
#define CLK_PWM6		16
#define CLK_PWM7		17
#define CLK_PWM8		18
#define CLK_PWM9		19
#define CLK_PWM10		20
#define CLK_PWM11		21
#define CLK_PWM12		22
#define CLK_PWM13		23
#define CLK_PWM14		24
#define CLK_PWM15		25
#define CLK_PWM16		26
#define CLK_PWM17		27
#define CLK_PWM18		28
#define CLK_PWM19		29
#define CLK_SSP3		30
#define CLK_RTC			31
#define CLK_TWSI0		32
#define CLK_TWSI1		33
#define CLK_TWSI2		34
#define CLK_TWSI4		35
#define CLK_TWSI5		36
#define CLK_TWSI6		37
#define CLK_TWSI7		38
#define CLK_TWSI8		39
#define CLK_TIMERS1		40
#define CLK_TIMERS2		41
#define CLK_AIB			42
#define CLK_ONEWIRE		43
#define CLK_SSPA0		44
#define CLK_SSPA1		45
#define CLK_DRO			46
#define CLK_IR			47
#define CLK_TSEN		48
#define CLK_IPC_AP2AUD		49
#define CLK_CAN0		50
#define CLK_CAN0_BUS		51
#define CLK_UART0_BUS		52
#define CLK_UART2_BUS		53
#define CLK_UART3_BUS		54
#define CLK_UART4_BUS		55
#define CLK_UART5_BUS		56
#define CLK_UART6_BUS		57
#define CLK_UART7_BUS		58
#define CLK_UART8_BUS		59
#define CLK_UART9_BUS		60
#define CLK_GPIO_BUS		61
#define CLK_PWM0_BUS		62
#define CLK_PWM1_BUS		63
#define CLK_PWM2_BUS		64
#define CLK_PWM3_BUS		65
#define CLK_PWM4_BUS		66
#define CLK_PWM5_BUS		67
#define CLK_PWM6_BUS		68
#define CLK_PWM7_BUS		69
#define CLK_PWM8_BUS		70
#define CLK_PWM9_BUS		71
#define CLK_PWM10_BUS		72
#define CLK_PWM11_BUS		73
#define CLK_PWM12_BUS		74
#define CLK_PWM13_BUS		75
#define CLK_PWM14_BUS		76
#define CLK_PWM15_BUS		77
#define CLK_PWM16_BUS		78
#define CLK_PWM17_BUS		79
#define CLK_PWM18_BUS		80
#define CLK_PWM19_BUS		81
#define CLK_SSP3_BUS		82
#define CLK_RTC_BUS		83
#define CLK_TWSI0_BUS		84
#define CLK_TWSI1_BUS		85
#define CLK_TWSI2_BUS		86
#define CLK_TWSI4_BUS		87
#define CLK_TWSI5_BUS		88
#define CLK_TWSI6_BUS		89
#define CLK_TWSI7_BUS		90
#define CLK_TWSI8_BUS		91
#define CLK_TIMERS1_BUS		92
#define CLK_TIMERS2_BUS		93
#define CLK_AIB_BUS		94
#define CLK_ONEWIRE_BUS		95
#define CLK_SSPA0_BUS		96
#define CLK_SSPA1_BUS		97
#define CLK_TSEN_BUS		98
#define CLK_IPC_AP2AUD_BUS	99

/* APBC resets */
#define RESET_UART0		0
#define RESET_UART2		1
#define RESET_UART3		2
#define RESET_UART4		3
#define RESET_UART5		4
#define RESET_UART6		5
#define RESET_UART7		6
#define RESET_UART8		7
#define RESET_UART9		8
#define RESET_GPIO		9
#define RESET_PWM0		10
#define RESET_PWM1		11
#define RESET_PWM2		12
#define RESET_PWM3		13
#define RESET_PWM4		14
#define RESET_PWM5		15
#define RESET_PWM6		16
#define RESET_PWM7		17
#define RESET_PWM8		18
#define RESET_PWM9		19
#define RESET_PWM10		20
#define RESET_PWM11		21
#define RESET_PWM12		22
#define RESET_PWM13		23
#define RESET_PWM14		24
#define RESET_PWM15		25
#define RESET_PWM16		26
#define RESET_PWM17		27
#define RESET_PWM18		28
#define RESET_PWM19		29
#define RESET_SSP3		30
#define RESET_RTC		31
#define RESET_TWSI0		32
#define RESET_TWSI1		33
#define RESET_TWSI2		34
#define RESET_TWSI4		35
#define RESET_TWSI5		36
#define RESET_TWSI6		37
#define RESET_TWSI7		38
#define RESET_TWSI8		39
#define RESET_TIMERS1		40
#define RESET_TIMERS2		41
#define RESET_AIB		42
#define RESET_ONEWIRE		43
#define RESET_SSPA0		44
#define RESET_SSPA1		45
#define RESET_DRO		46
#define RESET_IR		47
#define RESET_TSEN		48
#define RESET_IPC_AP2AUD	49
#define RESET_CAN0		50

/* APMU clocks */
#define CLK_CCI550		0
#define CLK_CPU_C0_HI		1
#define CLK_CPU_C0_CORE		2
#define CLK_CPU_C0_ACE		3
#define CLK_CPU_C0_TCM		4
#define CLK_CPU_C1_HI		5
#define CLK_CPU_C1_CORE		6
#define CLK_CPU_C1_ACE		7
#define CLK_CCIC_4X		8
#define CLK_CCIC1PHY		9
#define CLK_SDH_AXI		10
#define CLK_SDH0		11
#define CLK_SDH1		12
#define CLK_SDH2		13
#define CLK_USB_P1		14
#define CLK_USB_AXI		15
#define CLK_USB30		16
#define CLK_QSPI		17
#define CLK_QSPI_BUS		18
#define CLK_DMA			19
#define CLK_AES			20
#define CLK_VPU			21
#define CLK_GPU			22
#define CLK_EMMC		23
#define CLK_EMMC_X		24
#define CLK_AUDIO		25
#define CLK_HDMI		26
#define CLK_PMUA_ACLK		27
#define CLK_PCIE0_MASTER	28
#define CLK_PCIE0_SLAVE		29
#define CLK_PCIE0_DBI		30
#define CLK_PCIE1_MASTER	31
#define CLK_PCIE1_SLAVE		32
#define CLK_PCIE1_DBI		33
#define CLK_PCIE2_MASTER	34
#define CLK_PCIE2_SLAVE		35
#define CLK_PCIE2_DBI		36
#define CLK_EMAC0_BUS		37
#define CLK_EMAC0_PTP		38
#define CLK_EMAC1_BUS		39
#define CLK_EMAC1_PTP		40
#define CLK_JPG			41
#define CLK_CCIC2PHY		42
#define CLK_CCIC3PHY		43
#define CLK_CSI			44
#define CLK_CAMM0		45
#define CLK_CAMM1		46
#define CLK_CAMM2		47
#define CLK_ISP_CPP		48
#define CLK_ISP_BUS		49
#define CLK_ISP			50
#define CLK_DPU_MCLK		51
#define CLK_DPU_ESC		52
#define CLK_DPU_BIT		53
#define CLK_DPU_PXCLK		54
#define CLK_DPU_HCLK		55
#define CLK_DPU_SPI		56
#define CLK_DPU_SPI_HBUS	57
#define CLK_DPU_SPIBUS		58
#define CLK_DPU_SPI_ACLK	59
#define CLK_V2D			60
#define CLK_EMMC_BUS		61

/* APMU resets */
#define RESET_CCIC_4X		0
#define RESET_CCIC1_PHY		1
#define RESET_SDH_AXI		2
#define RESET_SDH0		3
#define RESET_SDH1		4
#define RESET_SDH2		5
#define RESET_USBP1_AXI		6
#define RESET_USB_AXI		7
#define RESET_USB30_AHB		8
#define RESET_USB30_VCC		9
#define RESET_USB30_PHY		10
#define RESET_QSPI		11
#define RESET_QSPI_BUS		12
#define RESET_DMA		13
#define RESET_AES		14
#define RESET_VPU		15
#define RESET_GPU		16
#define RESET_EMMC		17
#define RESET_EMMC_X		18
#define RESET_AUDIO_SYS		19
#define RESET_AUDIO_MCU		20
#define RESET_AUDIO_APMU	21
#define RESET_HDMI		22
#define RESET_PCIE0_MASTER	23
#define RESET_PCIE0_SLAVE	24
#define RESET_PCIE0_DBI		25
#define RESET_PCIE0_GLOBAL	26
#define RESET_PCIE1_MASTER	27
#define RESET_PCIE1_SLAVE	28
#define RESET_PCIE1_DBI		29
#define RESET_PCIE1_GLOBAL	30
#define RESET_PCIE2_MASTER	31
#define RESET_PCIE2_SLAVE	32
#define RESET_PCIE2_DBI		33
#define RESET_PCIE2_GLOBAL	34
#define RESET_EMAC0		35
#define RESET_EMAC1		36
#define RESET_JPG		37
#define RESET_CCIC2PHY		38
#define RESET_CCIC3PHY		39
#define RESET_CSI		40
#define RESET_ISP_CPP		41
#define RESET_ISP_BUS		42
#define RESET_ISP		43
#define RESET_ISP_CI		44
#define RESET_DPU_MCLK		45
#define RESET_DPU_ESC		46
#define RESET_DPU_HCLK		47
#define RESET_DPU_SPIBUS	48
#define RESET_DPU_SPI_HBUS	49
#define RESET_V2D		50
#define RESET_MIPI		51
#define RESET_MC		52

/*	RCPU resets	*/
#define RESET_RCPU_SSP0		0
#define RESET_RCPU_I2C0		1
#define RESET_RCPU_UART1	2
#define RESET_RCPU_IR		3
#define RESET_RCPU_CAN		4
#define RESET_RCPU_UART0	5
#define RESET_RCPU_HDMI_AUDIO	6

/*	RCPU2 resets	*/
#define RESET_RCPU2_PWM0	0
#define RESET_RCPU2_PWM1	1
#define RESET_RCPU2_PWM2	2
#define RESET_RCPU2_PWM3	3
#define RESET_RCPU2_PWM4	4
#define RESET_RCPU2_PWM5	5
#define RESET_RCPU2_PWM6	6
#define RESET_RCPU2_PWM7	7
#define RESET_RCPU2_PWM8	8
#define RESET_RCPU2_PWM9	9

/*	APBC2 resets	*/
#define RESET_APBC2_UART1	0
#define RESET_APBC2_SSP2	1
#define RESET_APBC2_TWSI3	2
#define RESET_APBC2_RTC		3
#define RESET_APBC2_TIMERS0	4
#define RESET_APBC2_KPC		5
#define RESET_APBC2_GPIO	6

#endif /* _DT_BINDINGS_SPACEMIT_CCU_H_ */
